//  -*- Mode: C++;  -*-

//  File: area.cpp

//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)

//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// * FUNCTION:	Calculates the Contributing Area divided by the base 

// *		length given an elevation grid. 

// *

// * RELATED PACKAGES: area_class.cpp stabfun.cpp grid.cpp

// *

// * HISTORY:

// * Created:  Tue Apr 27 1993 (dino, based on rob reiss' version)

// * Modified: Mon May 10 1999 (dino)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



// the following include file (notice.h) contains important copyright 

// information, as well as other legal statements. it must be present 

// in all files and in any distribution. removal or modification is

// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";

//

#include "stabfun.h"

#include "macros.h"



#define MESSAGES        1



int main (int argc, char **argv) 

{

	int mode, type;



        if (argc < 2 || argc > 4)

        {

#if (MESSAGES)

                // invalid arguments, print usage

		cerr << "usage:\n";

                cerr << "\t" << appName(argv) << " <elevation grid> [<format> <mode>]\n";

                cerr << "formats:\n";

                cerr << "\t0 = arcinfo ascii (default)\n";

                cerr << "\t1 = surfer ascii\n";

                cerr << "modes:\n";

                cerr << "\t0 = area/cell size (default)\n";

                cerr << "\t1 = area\n";

                cerr << "example:\n";

                cerr << "\t" << appName(argv) << " elev.grd > area.grd\n";

#endif

                exit(1);

        }

 

        if (argc < 3 || (type = atoi(argv[2])) <= 0 || type > 1)

                type = ARCINFO;

	else

		type = SURFER;



        if (argc < 4 || (mode = atoi(argv[3])) <= 0 || mode > 1)

                mode = CA_AOVERB;

	else

		mode = CA_AREA;



	do_Area(argv[1], (char *)NULL, type, mode, TRUE, MESSAGES);



        exit(FALSE);    

        return(TRUE);

}

